<div class="bootstrap-iso">
    <div id="app" class="container calc-table">
        <div class="row">
            <div class="col-md-12 card  shadow-sm ">
                <div class="item mt-2 border-link">
                    <div class="row text-center ">

                        <div class="text-left col-md-12" style="text-align:left;">
                            <p>

                                This calculator compares <b>EXAMPLE RATIONS</b> using general feed ingredients for cost comparison purposes. 
                                Producers can formulate an appropriate ration for their cattle in consultation with a qualified nutritionist, 
                                ag extension staff or through a software program like CowBytes. When considering alternative feed sources, 
                                feed testing is important to test for nutritive value and ensure a balanced ration that meets the cattle’s nutritional needs and quality (e.g. mycotoxins).
                                <a href="https://www.beefresearch.ca/blog/new-feed-testing-tools/#economicValueTitle" target="_blank">Evaluate feed test results HERE</a>. 
                                Other costs such as yardage or labour are excluded.
                            </p>
                            <p class="p-1 m-1 alert alert-success"> Step 1: Enter local price and relevant
                                units in the <strong>green cells </strong> (choose unit from the drop-down list).</p>
                            <p class="p-1 m-1 alert alert-primary">Step 2: Enter herd information in
                                <strong>blue cells. </strong>
                            </p>
                            <p class="p-1 m-1 alert alert-warning"> Step 3: Enter ration information in
                                <strong>yellow cells </strong>(pounds of each ration ingredient on an as-fed basis. Numbers already included are EXAMPLE RATIONS only).
                            </p>
                            <p class="p-1 m-1 alert alert-secondary"> Step 4: Compare costs per head per
                                day and total herd costs of alternative rations in
                                <strong> grey cells.</strong>
                            </p>

                        </div>

                        <section class="container" id="app">
                            <div class="row ">
                                <div class="col-md-12">
                                    <div class=" mb-3  row">

                                        <div class="table-style table-responsive">
                                            <table class="table table-sm rounded">
                                                <thead>

                                                    <tr class="bg-darkgreen  front-line">
                                                        <th class="p-3 bg-darkgreen front-line" style="color: white;"> </th>
                                                        <th class="p-3  bg-darkgreen front-line " colspan="3" style="color: white;"> Local
                                                            Price**</th>
                                                        <th class="p-3  bg-darkgreen front-line " colspan="8" style="color: white;"> <b>Example Rations (pounds as fed)</b><br>
                                                        Rations 1-6 are presented as pounds per cow per day on an as fed basis
                                                        </th>

                                                    </tr>
                                                    <tr class="bg-darkgreen " style="color: white;">
                                                        <th class="p-3 bg-darkgreen" >Main Ingredient </th>
                                                        <th class="p-3  bg-darkgreen" style="width: 82px !important;"> $/Unit</th>
                                                        <th class="p-3  bg-darkgreen" >Unit <br>(dropdown)</th>
                                                        <th class="p-3  bg-darkgreen" style="width: 82px !important;"> $/lb</th>
                                                        <th class="p-3  bg-darkgreen" > #1 </th>
                                                        <th class="p-3  bg-darkgreen" > #2 </th>
                                                        <th class="p-3  bg-darkgreen" > #3 </th>
                                                        <!-- <th class="p-3  bg-darkgreen" style="min-width:110px;"> #4 </th> -->
                                                        <!-- <th class="p-3  bg-darkgreen" style="min-width:110px;"> #5 </th> -->
                                                        <th class="p-3  bg-darkgreen" > #4 </th>
                                                        <th class="p-3  bg-darkgreen" > #5 </th>
                                                        <th class="p-3  bg-darkgreen" > #6</th>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td class="font-weight-bold">Hay </td>
                                                        <td>
                                                            <vue-numeric type="text" :empty-value="1" :precision="2" v-model="B13" class="bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C13">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td style="min-width:75px;">
                                                            <vue-numeric readonly :value="D13" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E13" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F13" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G13" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H13" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I13" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J13" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K13" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L13" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Cereal Straw </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B14" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C14">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D14" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E14" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F14" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G14" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H14" :precision="1" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I14" :precision="1" class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J14" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K14" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L14" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Cereal Silage*** </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B15" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C15">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D15" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E15" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F15" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G15" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H15" :precision="1" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I15" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J15" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K15" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L15" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Cereal Greenfeed </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B16" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C16">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D16" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E16" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F16" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G16" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H16" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I16" :precision="1" class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J16" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K16" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L16" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Barley Grain </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B17" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C17">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D17" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E17" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F17" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G17" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H17" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I17" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J17" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K17" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L17" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Corn </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B18" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C18">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D18" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E18" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F18" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G18" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H18" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I18" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J18" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K18" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L18" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Ground Canola </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B19" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C19">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D19" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E19" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F19" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G19" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H19" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I19" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J19" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K19" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L19" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Pellets </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B20" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C20">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D20" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E20" :precision="2" class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F20" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G20" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H20" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I20" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J20" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K20" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L20" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Other </br>(i.e. Mineral) </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B21" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C21">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D21" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E21" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F21" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G21" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H21" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I21" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J21" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K21" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L21" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Other <br>(i.e. Protein Supplement)
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B22" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C22">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D22" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E22" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F22" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G22" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H22" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I22" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J22" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K22" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L22" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Other </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B23" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C23">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D23" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E23" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F23" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G23" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H23" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I23" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J23" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K23" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L23" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">Other </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="B24" :precision="2" class=" bg-green form-control">
                                                            </vue-numeric>
                                                        </td>

                                                        <td>
                                                            <select name="" id="" class=" bg-green form-select form-control" v-model="C24">
                                                                <option value="lb">lb</option>
                                                                <option value="ton">ton</option>
                                                                <option value="tonne">tonne</option>
                                                                <option value="kg">kg</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <vue-numeric readonly :value="D24" :precision="3" class="form-control bg-grey"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="E24" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="F24" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="G24" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td>
                                                            <vue-numeric v-model="H24" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-model="I24" :precision="1" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td> -->
                                                        <td>
                                                            <vue-numeric type="text" v-model="J24" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="K24" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <td>
                                                            <vue-numeric type="text" v-model="L24" :precision="2" placeholder=" " class="form-control bg-yellow"> </vue-numeric>
                                                        </td>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr class="bg-highlight">
                                                        <td class="font-weight-bold text-left">Total Intake <br>(lbs as
                                                            fed)* </td>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumE13" :precision="2" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumF13" :precision="2" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumG13" :precision="2" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <!-- <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumH13" :precision="1" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumI13" :precision="1" class="form-control ">
                                                            </vue-numeric>
                                                        </th> -->
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumJ13" :precision="2" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumK13" :precision="2" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">
                                                            <vue-numeric readonly disabled :value="SumL13" :precision="2" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr class="bg-highlight">
                                                        <td class="font-weight-bold text-left ">Total Days on Feed </td>

                                                        <th class="text-center">
                                                            <vue-numeric type="text" v-model="B26" style="font-size: 16px;outline: none; border:none" ref="B26" class="form-control text-center bg-blue" id="B26">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        <!-- </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center"> -->

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr class="bg-highlight">
                                                        <td class="font-weight-bold text-left ">Herd Size </td>

                                                        <th class="text-center">
                                                            <vue-numeric type="text" v-model="B27" style="font-size: 16px;outline: none; border:none" ref="B27" class="form-control text-center bg-blue" id="B27">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        <!-- </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center"> -->

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <th class="text-center">

                                                        </th>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                    <tr class="bg-highlight">
                                                        <td colspan="3" style="text-align: left;" class="font-weight-bold">Estimated Feed Cost Per Head Per Day</td>

                                                        <td></td>

                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="E28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="F28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="G28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <!-- <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="H28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="I28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th> -->
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="J28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="K28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="L28" :precision="2" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>


                                                    <tr class="bg-highlight text-left">
                                                        <td colspan="3" style="text-align: left;" class="font-weight-bold text-left">Total Winter Feed Costs (for Herd)</td>

                                                        <td></td>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="E29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="F29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="G29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <!-- <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="H29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="I29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th> -->
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="J29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="K29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <th class="text-center result" >
                                                            <vue-numeric readonly disabled :value="L29" currency="$" class="form-control ">
                                                            </vue-numeric>
                                                        </th>
                                                        <!-- <td style="color: #007bff;">.</td> -->
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>



                                        <div class="row">
                                            <div class="col-md-12" style="text-align:left;">
                                                <p class="p-1 m-1 alert alert-success" role="alert">
                                                    * Total lbs of dry matter intake should be between 2-2.5% of body
                                                    weight.
                                                    <strong> Note:</strong> this is lbs "as fed" and not on a dry matter
                                                    basis
                                                </p>
                                                <p class="p-1 m-1 alert alert-success" role="alert">
                                                    ** 1 ton = 0.907 tonne

                                                </p>
                                                <p class="p-1 m-1 alert alert-success" role="alert">
                                                    *** Moisture content of silage is typically high, hence total intake
                                                    as fed is higher compared to hay-based ration.
                                                </p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-2">
                                            </div>
                                            <div class="col-md-12 card shadow-sm text-center">
                                                <span style="font-size:22px; font-weight:bold" class="text-muted"> Alternative Winter Feeding Ration Cost Per Head Per Day</span>
                                                <v-chart autoresize class="pl-2" style="width:100%;height:300px;" class="ml-3" :option="chart1" />

                                            </div>

                                        </div>
                                        <div class="row text-center pl-4 mt-3 mb-3">

                                            <span style="font-size:22px; font-weight:bold" class="text-muted">Alternative Winter Feeding Ration Cost for the Total Herd</span>

                                            <div class="col-md-2">
                                            </div>
                                            <div class="col-md-12 card shadow-sm text-center">
                                                <v-chart autoresize style="width:100%;height:300px;" class="ml-3" :option="chart2" />

                                            </div>

                                        </div>

                                        <div class="row  mt-3 mb-3">


                                            <div class="col-md-12 text-left float-left card shadow-sm" style="text-align:left;">
                                                <p class="p-1 m-1" >
                                                    <strong>The Winter Feed Cost Calculator was based upon the following resources:</strong>
                                                </p>
                                                <p class="p-1 m-1" >
                                                    <a href="https://open.alberta.ca/dataset/fcc09957-b061-4e58-a8e0-a3bfce530d01/resource/02cbe349-a731-4f9c-913d-96437765c218/download/2007-420-52-2.pdf
                                                        " target="_blank">Alberta Ministry of Agriculture and Irrigation: Ration Options for Beef Cows</a>
                                                </p>
                                                <p class="p-1 m-1" >
                                                    <a href="https://www.saskatchewan.ca/business/agriculture-natural-resources-and-industry/agribusiness-farmers-and-ranchers/livestock/cattle-poultry-and-other-livestock/cattle/beef-cow-rations-and-winter-feeding-guidelines" target="_blank">
                                                            Saskatchewan Ministry of Agriculture: Beef Cow Rations and Winter Feeding Guidelines
                                                </p>

                                                <p class="p-1 m-1" >
                                                    <a href="https://www.gov.mb.ca/agriculture/farm-management/production-economics/cost-of-production.html
                                                        " target="_blank">Manitoba Ministry of Agriculture: Cost of Production Guides & Calculators</a>
                                                </p>

                                                <p class="p-1 m-1" >
                                                    <a href="http://omafra.gov.on.ca/english/livestock/beef/facts/16-051.htm
                                                        " target="_blank">OMAFRA: Alternative Forages and Sample Wintering Rations for Beef Cows</a>
                                                </p>
                                                <p class="p-1 m-1">
                                                    <a href="https://www.ontario.ca/page/coping-hay-shortages-beef-cow-wintering-rations
                                                        " target="_blank"> Coping with hay shortages in beef cow wintering rations</a>
                                                </p>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </div>



                        </section>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>